#pragma once

#include "SkinManager.h"

#define		SKIN_MENU_MAGIC		0x2010		// Ƥ˵ĿϢʶ

struct SKIN_MENU_ITEM_INFO					// Ƥ˵ĿϢṹ
{
	UINT nMagic;							// Ƥ˵ĿϢʶ
	UINT nID;								// ˵ID
	UINT nState;							// ˵״̬
	UINT nType;								// 
	HMENU hSubMenu;							// ӵ(ʽ˵)
	TCHAR szText[256];						// ˵ı
	CImageEx * lpIconImgN;					// δѡͼ
	CImageEx * lpIconImgH;					// ѡͼ
};

class CSkinMenu								// Ƥ˵װ
{
public:
	CSkinMenu(HMENU hMenu = NULL);
	~CSkinMenu(void);

public:
	BOOL SetBgPic(LPCTSTR lpszLeftBg, LPCTSTR lpszRightBg);	// ò˵ͼƬ
	BOOL SetSelectedPic(LPCTSTR lpszFileName);		// ò˵ѡͼƬ
	BOOL SetSepartorPic(LPCTSTR lpszFileName);		// ÷ָͼƬ
	BOOL SetArrowPic(LPCTSTR lpszFileName);			// õʽ˵ͷͼƬ
	BOOL SetCheckPic(LPCTSTR lpszFileName);			// Check״̬ͼƬ
	BOOL SetIcon(UINT nItem, BOOL bByPosition, LPCTSTR lpszIconN, LPCTSTR lpszIconH);	// ָ˵ʹõͼ

	void SetTextColor(COLORREF clrText);			// ͨ˵ıɫ
	void SetSelTextColor(COLORREF clrSelText);		// ѡв˵ıɫ
	void SetGrayedTextColor(COLORREF clrGrayedText);// ûһ˵ıɫ

public:
	BOOL CreateMenu();
	BOOL CreatePopupMenu();
	BOOL LoadMenu(LPCWSTR lpszResourceName);
	BOOL LoadMenu(UINT nIDResource);
	BOOL DestroyMenu();

	void OnInitMenuPopup(HMENU hMenuPopup, UINT nIndex, BOOL bSysMenu);
	void OnMeasureItem(int nIDCtl, LPMEASUREITEMSTRUCT lpMeasureItemStruct);
	void OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct);

	CSkinMenu& operator =(HMENU hMenu);

	BOOL Attach(HMENU hMenu);
	HMENU Detach();

	BOOL DeleteMenu(UINT nPosition, UINT nFlags);
	BOOL TrackPopupMenu(UINT nFlags, int x, int y, HWND hWnd, LPCRECT lpRect = 0);
	BOOL TrackPopupMenuEx(UINT fuFlags, int x, int y, HWND hWnd, LPTPMPARAMS lptpm);

	BOOL AppendMenu(UINT nFlags, UINT_PTR nIDNewItem = 0,
		LPCTSTR lpszNewItem = NULL);
	UINT CheckMenuItem(UINT nIDCheckItem, UINT nCheck);
	UINT EnableMenuItem(UINT nIDEnableItem, UINT nEnable);
	UINT GetMenuItemCount() const;
	UINT GetMenuItemID(int nPos) const;
	UINT GetMenuState(UINT nID, UINT nFlags);
	int GetMenuString(UINT nIDItem, LPTSTR lpString, int nMaxCount, UINT nFlags);
	CSkinMenu GetSubMenu(int nPos) const;
	BOOL InsertMenu(UINT nPosition, UINT nFlags, 
		UINT_PTR nIDNewItem = 0, LPCTSTR lpszNewItem = NULL);
	BOOL ModifyMenu(UINT nPosition, UINT nFlags, 
		UINT_PTR nIDNewItem = 0, LPCTSTR lpszNewItem = NULL);
	BOOL RemoveMenu(UINT nPosition, UINT nFlags);
	BOOL CheckMenuRadioItem(UINT nIDFirst, UINT nIDLast, UINT nIDItem, UINT nFlags);

	BOOL IsMenu();

private:
	SKIN_MENU_ITEM_INFO * GetMenuItemInfo(UINT nItem, BOOL bByPosition);	// ȡָ˵Ϣݺ
	BOOL SetMenuItemInfo(UINT nItem, BOOL bByPosition, SKIN_MENU_ITEM_INFO * lpItemInfo);	// ָ˵Ϣݺ

	BOOL EnableOwnerDraw(HMENU hMenu, BOOL bEnable);			// ʹܲ˵Ի

	SIZE GetTextExtent(LPCTSTR lpszText);						// ȡֵָĿ߶

	void DrawBg(HDC hDC, CRect& rect);							// Ʋ˵
	void DrawSepartor(HDC hDC, CRect& rect);					// Ʒָ
	void DrawSelRect(HDC hDC, CRect& rect);						// ѡ
	void DrawIcon(HDC hDC, CRect& rect, CImageEx * lpIconImg);	// Ʋ˵ͼ
	void DrawCheckState(HDC hDC, CRect& rect);					// Check״̬
	void DrawText(HDC hDC, CRect& rect, BOOL bGrayed,			// Ʋ˵ı
		BOOL bSelected, BOOL bIsSubMenu, LPCTSTR lpText);	
	void DrawArrow(HDC hDC, CRect& rect);						// Ƶʽ˵ͷ

public:
	HMENU m_hMenu;							// ˵

private:
	CImageEx * m_lpBgImgL, * m_lpBgImgR;	// ˵ͼƬ
	CImageEx * m_lpSelectedImg;				// ˵ѡͼƬ
	CImageEx * m_lpSepartorImg;				// ָͼƬ
	CImageEx * m_lpArrowImg;				// ʽ˵ͷͼƬ
	CImageEx * m_lpCheckImg;				// Check״̬ͼƬ

	COLORREF m_clrText;						// ͨ˵ıɫ
	COLORREF m_clrSelText;					// ѡв˵ıɫ
	COLORREF m_clrGrayedText;				// һ˵ıɫ

	HFONT m_hFont;							// ˵
	int m_nLMargin;							// 
};